<?php

/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/zf2 for the canonical source repository
 * @copyright Copyright (c) 2005-2012 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 * @package   Zend_Search
 */

namespace ZendSearch\Lucene\Search\QueryEntry;

/**
 * @category   Zend
 * @package    Zend_Search_Lucene
 * @subpackage Search
 */
class Term extends AbstractQueryEntry
{
    /**
     * Term value
     *
     * @var string
     */
    private $_term;

    /**
     * Field
     *
     * @var string|null
     */
    private $_field;


    /**
     * Fuzzy search query
     *
     * @var boolean
     */
    private $_fuzzyQuery = false;

    /**
     * Similarity
     *
     * @var float
     */
    private $_similarity = 1.;


    /**
     * Object constractor
     *
     * @param string $term
     * @param string $field
     */
    public function __construct($term, $field)
    {
        $this->_term  = $term;
        $this->_field = $field;
    }

    /**
     * Process modifier ('~')
     *
     * @param mixed $parameter
     *
     * @return void
     */
    public function processFuzzyProximityModifier($parameter = null)
    {
        $this->_fuzzyQuery = true;

        if ($parameter !== null) {
            $this->_similarity = $parameter;
        } else {
            $this->_similarity = \ZendSearch\Lucene\Search\Query\Fuzzy::DEFAULT_MIN_SIMILARITY;
        }
    }

    /**
     * Transform entry to a subquery
     *
     * @param string $encoding
     * @return \ZendSearch\Lucene\Search\Query\AbstractQuery
     * @throws \ZendSearch\Lucene\Search\Exception\QueryParserException
     */
    public function getQuery($encoding)
    {
        if ($this->_fuzzyQuery) {
            $query = new \ZendSearch\Lucene\Search\Query\Preprocessing\Fuzzy(
                $this->_term,
                $encoding,
                ($this->_field !== null) ?
                                                                                  iconv($encoding, 'UTF-8', $this->_field) :
                                                                                  null,
                $this->_similarity
            );
            $query->setBoost($this->_boost);
            return $query;
        }


        $query = new \ZendSearch\Lucene\Search\Query\Preprocessing\Term(
            $this->_term,
            $encoding,
            ($this->_field !== null) ?
                                                                              iconv($encoding, 'UTF-8', $this->_field) :
                                                                              null
        );
        $query->setBoost($this->_boost);
        return $query;
    }
}
