humhub.module('live', function (module, require, $) {
    var object = require('util').object;
    var event = require('event');
    var liveClient;

    var init = function () {
        if (!module.config.isActive) {
            return;
        }

        try {
            var clientType = require(module.config.client.type);
            if (clientType) {
                liveClient = new clientType(module.config.client.options);
            } else {
                module.log.warn("Invalid live client configuration detected, live client could not be initialized.", module.config);
            }
        } catch (e) {
            module.log.warn("Invalid live client configuration detected, live client could not be initialized.", module.config);
            module.log.error(e);
        }

        event.on('humhub:modules:live:live:PreventPjaxOnNextClick', function (evt, liveEvents) {
            module.log.debug('Prevent PJAX on next click by reason: ' + liveEvents.map(item => item.data.reason).join(', '));
            $('a').attr('data-pjax-prevent', '1');
        });
    };

    var setDelay = function (value) {
        if (object.isFunction(liveClient.setDelay)) {
            liveClient.setDelay(value);
        }
    };

    module.export({
        init: init,
        setDelay: setDelay
    });
});
