Upgrading Instructions for Yii Framework v2 AuthClient Extension
================================================================

!!!IMPORTANT!!!

The following upgrading instructions are cumulative. That is,
if you want to upgrade from version A to version C and there is
version B between A and C, you need to following the instructions
for both A and B.

Upgrade from yii2-authclient 2.2.5
----------------------------------

* Default request option for turning off SSL peer verification was removed.
  If you need to skip peer verification you can configure individual client request options:
  
  ```php
  return [
      'components' => [
          'authClientCollection' => [
              'class' => 'yii\authclient\Collection',
              'clients' => [
                  'google' => [
                      'class' => 'yii\authclient\clients\Google',
                      'clientId' => 'google_client_id',
                      'clientSecret' => 'google_client_secret',
                      'requestOptions' => [
                          'sslVerifyPeer' => false, // <-- here
                      ],
                  ],
                  // etc.
              ],
          ]
          // ...
      ],
      // ...
  ];
  ```
  
Upgrade from yii2-authclient 2.1.0
----------------------------------

* The signature of the `yii\authclient\BaseOAuth::saveAccessToken()` method has been changed.
  In case you are extending related class and override this method, you should check, if it matches parent declaration.


Upgrade from yii2-authclient 2.0.6
----------------------------------

* Class `yii\authclient\clients\GoogleOAuth` has been renamed to `yii\authclient\clients\Google`.
  Make sure you are using correct name for this class.

* Class `yii\authclient\clients\YandexOAuth` has been renamed to `yii\authclient\clients\Yandex`.
  Make sure you are using correct name for this class.

* The signature of the following methods has been changed: `yii\authclient\BaseOAuth::sendRequest()`, `yii\authclient\BaseOAuth::api()`,
  `yii\authclient\OAuth1::composeSignatureKey()`, `yii\authclient\OAuth1::composeAuthorizationHeader()`, `yii\authclient\OAuth1::fetchAccessToken()`,
  `yii\authclient\widgets\AuthChoice::createClientUrl()`. Make sure you invoke those methods correctly.
  In case you are extending related classes, you should check, if overridden methods match parent declaration.

* Virtual property `yii\authclient\BaseOAuth::curlOptions` and related methods have been removed -
  use `yii\authclient\BaseOAuth::requestOptions` instead.

* Following methods have been removed: `yii\authclient\OAuth1::sendSignedRequest()`, `yii\authclient\BaseOAuth::processResponse()`,
  `yii\authclient\BaseOAuth::apiInternal()`, `yii\authclient\BaseOAuth::convertXmlToArray()`, `yii\authclient\BaseOAuth::determineContentTypeByHeaders()`,
  `yii\authclient\BaseOAuth::determineContentTypeByRaw()`.
  Make sure you do not invoke them.

* Class `yii\authclient\InvalidResponseException` reworked: fields `responseHeaders` and `responseBody` have been removed,
  field `response` added instead, holding `yii\httpclient\Response` instance. Class constructor adjusted accordingly.
  Make sure you throw and process this exception correctly.

* Method `yii\authclient\BaseClient::initUserAttributes()` has been made abstract.
  If you extend `yii\authclient\BaseClient` class, make sure you provide implementation for this method,
  or declare your class as abstract.

* Classes `yii\authclient\OAuth1` and `yii\authclient\OAuth2` have been made abstract.
  Make sure you do not instantiate these classes.

* Classes `yii\authclient\clients\GoogleOpenId` and `yii\authclient\clients\YandexOpenId` have been removed,
  since Google and Yandex no longer supports OpenID protocol. Make sure you do not use or refer these classes.

* Methods `clientLink()` and `renderMainContent()` of `yii\authclient\widgets\AuthChoice` has been changed to return
  the generated HTML instead of echo it. Make sure you invoke or override these methods correctly.

* Markup generated by `yii\authclient\widgets\AuthChoice` and related CSS has been simplified.
  In case you customize styles or HTML for `AuthChoice`, you should check it to produce valid widget appearance.

* Automatic auth 'state' validation added to `yii\authclient\OAuth2`.
  In case state validation is not supported or not desirable for your particular client, you should disabled it
  setting `yii\authclient\OAuth2::validateAuthState` to `false`.
