<?php

declare (strict_types=1);
namespace RectorPrefix202509;

use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\MethodCall\RenameMethodRector;
use Rector\Renaming\Rector\Name\RenameClassRector;
use Rector\Renaming\ValueObject\MethodCallRename;
return static function (RectorConfig $rectorConfig): void {
    $rectorConfig->ruleWithConfiguration(RenameMethodRector::class, [new MethodCallRename('Symfony\Component\BrowserKit\Response', 'getStatus', 'getStatusCode')]);
    $rectorConfig->ruleWithConfiguration(RenameClassRector::class, ['Symfony\Component\BrowserKit\Client' => 'Symfony\Component\BrowserKit\AbstractBrowser']);
};
