<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2017 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 */

namespace humhub\components;

/**
 * Response
 *
 * @author Luke
 */
class Response extends \yii\web\Response
{
    public function init()
    {
        if (defined('YII_ENV_TEST') && YII_ENV_TEST && class_exists('indexTextResponseCode', false)) {
            \indexTextResponseCode::$response = $this;
        }

        parent::init();
    }

    /**
     * @inheritdoc
     */
    public function xSendFile($filePath, $attachmentName = null, $options = [])
    {
        if (preg_match('/nginx|frankenphp/i', $_SERVER['SERVER_SOFTWARE'] ?? '')) {
            // set nginx specific X-Sendfile header name
            $options['xHeader'] = 'X-Accel-Redirect';
            // make path relative to docroot
            $docroot = rtrim((string) $_SERVER['DOCUMENT_ROOT'], DIRECTORY_SEPARATOR);
            if (str_starts_with($filePath, $docroot)) {
                $filePath = substr($filePath, strlen($docroot));
            }
        }

        return parent::xSendFile($filePath, $attachmentName, $options);
    }
}
