declare const _default: {
    generateKeyPair: typeof generateKeyPair;
    encrypt: typeof encrypt;
    decrypt: typeof decrypt;
    exportPrivateKey: typeof exportPrivateKey;
    exportPrivateKeyPem: typeof exportPrivateKeyPem;
    exportPublicKey: typeof exportPublicKey;
    exportPublicKeyPem: typeof exportPublicKeyPem;
    exportPublicKeyFromPrivateKey: typeof exportPublicKeyFromPrivateKey;
    importPrivateKey: typeof importPrivateKey;
    importPrivateKeyPem: typeof importPrivateKeyPem;
    importPublicKey: typeof importPublicKey;
    importPublicKeyPem: typeof importPublicKeyPem;
};
export default _default;
export declare function generateKeyPair(): Promise<CryptoKeyPair>;
export declare function encrypt(publicKey: CryptoKey, data: Uint8Array): Promise<Uint8Array>;
export declare function decrypt(privateKey: CryptoKey, data: Uint8Array): Promise<Uint8Array>;
export declare function exportPublicKey(key: CryptoKey): Promise<Uint8Array>;
export declare function exportPrivateKey(key: CryptoKey): Promise<Uint8Array>;
export declare function exportPublicKeyPem(key: CryptoKey): Promise<string>;
export declare function exportPrivateKeyPem(key: CryptoKey): Promise<string>;
export declare function importPublicKey(key: Uint8Array): Promise<CryptoKey>;
export declare function importPublicKeyPem(pem: string): Promise<CryptoKey>;
export declare function importPrivateKey(key: Uint8Array): Promise<CryptoKey>;
export declare function importPrivateKeyPem(pem: string): Promise<CryptoKey>;
export declare function exportPublicKeyFromPrivateKey(privateKey: CryptoKey): Promise<Uint8Array>;
export declare function getPublicKeyId(pubKeyBytes: Uint8Array): Promise<string>;
