/*
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2017 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 *
 */

import {wrappingInputRule} from "prosemirror-inputrules"

// : (NodeType) → InputRule
// Given a blockquote node type, returns an input rule that turns `"> "`
// at the start of a textblock into a blockquote.
const bulletListRule = (schema) => {
    return wrappingInputRule(/^\s*([-+*])\s$/, schema.nodes.bullet_list)
};

export {bulletListRule};